/*
 * Decompiled with CFR 0.152.
 */
package com.riverstone.unknown303.errorlib.api.helpers.trim.material;

import com.riverstone.unknown303.errorlib.api.general.ModInfo;
import com.riverstone.unknown303.errorlib.api.helpers.ErrorLibHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;

public class TrimMaterialHelper
extends ErrorLibHelper {
    private static final LinkedHashMap<ResourceKey<TrimMaterial>, Item> trimMaterialItems = new LinkedHashMap();
    private static final LinkedHashMap<ResourceKey<TrimMaterial>, TextColor> trimMaterialTextColors = new LinkedHashMap();
    private static final LinkedHashMap<ResourceKey<TrimMaterial>, TrimMaterialColor> trimMaterialColors = new LinkedHashMap();

    public TrimMaterialHelper(ModInfo modInfo) {
        super(modInfo);
    }

    public void registerTrimMaterial(String name, Item item, TextColor textColor, TrimMaterialColor color) {
        ResourceKey trimKey = ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.getModId(), (String)name));
        trimMaterialItems.put((ResourceKey<TrimMaterial>)trimKey, item);
        trimMaterialTextColors.put((ResourceKey<TrimMaterial>)trimKey, textColor);
        trimMaterialColors.put((ResourceKey<TrimMaterial>)trimKey, color);
    }

    public void bootstrap(BootstapContext<TrimMaterial> context) {
        for (ResourceKey<TrimMaterial> trimMaterial : trimMaterialItems.keySet()) {
            Item item = trimMaterialItems.get(trimMaterial);
            TextColor textColor = trimMaterialTextColors.get(trimMaterial);
            TrimMaterialColor color = trimMaterialColors.get(trimMaterial);
            this.register(context, trimMaterial, item, Style.f_131099_.m_131148_(textColor), color);
        }
    }

    public void register(BootstapContext<TrimMaterial> context, ResourceKey<TrimMaterial> trimKey, Item item, Style style, TrimMaterialColor itemModelIndex) {
        TrimMaterial trimMaterial = TrimMaterial.m_267605_((String)trimKey.m_135782_().m_135815_(), (Item)item, (float)TrimMaterialColor.getItemModelIndex(itemModelIndex), (Component)Component.m_237115_((String)Util.m_137492_((String)"trim_material", (ResourceLocation)trimKey.m_135782_())).m_130948_(style), Map.of());
        context.m_255272_(trimKey, (Object)trimMaterial);
    }

    public static enum TrimMaterialColor {
        QUARTZ,
        IRON,
        NETHERITE,
        REDSTONE,
        COPPER,
        GOLD,
        EMERALD,
        DIAMOND,
        LAPIS,
        AMETHYST;


        public static float getItemModelIndex(TrimMaterialColor materialColor) {
            if (materialColor == QUARTZ) {
                return 0.1f;
            }
            if (materialColor == IRON) {
                return 0.2f;
            }
            if (materialColor == NETHERITE) {
                return 0.3f;
            }
            if (materialColor == REDSTONE) {
                return 0.4f;
            }
            if (materialColor == COPPER) {
                return 0.5f;
            }
            if (materialColor == GOLD) {
                return 0.6f;
            }
            if (materialColor == EMERALD) {
                return 0.7f;
            }
            if (materialColor == DIAMOND) {
                return 0.8f;
            }
            if (materialColor == LAPIS) {
                return 0.9f;
            }
            return 1.0f;
        }
    }
}

