/*
 * Decompiled with CFR 0.152.
 */
package com.riverstone.unknown303.errorlib.api.helpers.tier;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.TierSortingRegistry;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class TierInfo {
    private final Logger logger;
    private final int durability;
    private final float attackSpeed;
    private final float tierAttackDamage;
    private final int enchantability;
    @NotNull
    private TagKey<Block> miningTag;
    @Nullable
    private Ingredient repairIngredient;
    @Nullable
    private Tier lowerRank;
    @Nullable
    private Tier higherRank;
    private boolean isEquivalent = false;
    private static final TagKey<Block> EMPTY = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"errorlib", (String)"empty"));
    private static final TagKey<Block> EQUAL_RANK = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"errorlib", (String)"equal"));

    public TierInfo(Logger logger, int durability, float attackSpeed, float tierAttackDamage, int enchantability) {
        this.logger = logger;
        this.durability = durability;
        this.attackSpeed = attackSpeed;
        this.tierAttackDamage = tierAttackDamage;
        this.enchantability = enchantability;
        this.miningTag = EMPTY;
        this.repairIngredient = Ingredient.f_43901_;
        this.lowerRank = null;
        this.higherRank = null;
    }

    public TierInfo miningTag(TagKey<Block> miningTag) {
        if (this.isEquivalent) {
            IllegalStateException exception = new IllegalStateException("Error: TierInfo is using an equivalent rank");
            this.logger.error("Error: TierInfo is using an equivalent rank", (Throwable)exception);
        }
        this.miningTag = miningTag;
        return this;
    }

    public TierInfo repairIngredient(ItemLike repairIngredient) {
        this.repairIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{repairIngredient});
        return this;
    }

    public TierInfo lowerRank(Tier lowerRank) {
        IllegalStateException exception;
        if (this.isEquivalent) {
            exception = new IllegalStateException("Error: TierInfo is using an equivalent rank");
            this.logger.error("Error: TierInfo is using an equivalent rank", (Throwable)exception);
        }
        if (lowerRank == null) {
            exception = new IllegalStateException("Error: Lower Rank must be valid");
            this.logger.error("Error: Lower Rank must be valid", (Throwable)exception);
        }
        this.lowerRank = lowerRank;
        return this;
    }

    public TierInfo higherRank(Tier higherRank) {
        IllegalStateException exception;
        if (this.isEquivalent) {
            exception = new IllegalStateException("Error: TierInfo is using an equivalent rank");
            this.logger.error("Error: TierInfo is using an equivalent rank", (Throwable)exception);
        }
        if (higherRank == null) {
            exception = new IllegalStateException("Error: Higher Rank must be valid");
            this.logger.error("Error: Higher Rank must be valid", (Throwable)exception);
        }
        this.higherRank = higherRank;
        return this;
    }

    public TierInfo equalRank(Tier equalRank) {
        this.lowerRank = equalRank;
        this.higherRank = null;
        boolean nextIsHigher = false;
        for (Tier tier : TierSortingRegistry.getSortedTiers()) {
            if (nextIsHigher) {
                this.higherRank = tier;
                break;
            }
            if (!tier.equals(equalRank)) continue;
            nextIsHigher = true;
        }
        this.miningTag = equalRank.getTag() != null ? equalRank.getTag() : EQUAL_RANK;
        return this;
    }

    public int getLevel() {
        if (this.isEquivalent) {
            return this.lowerRank.m_6604_();
        }
        if (this.lowerRank != null && this.higherRank != null) {
            return (this.lowerRank.m_6604_() + this.higherRank.m_6604_()) / 2;
        }
        return 0;
    }

    public int getDurability() {
        return this.durability;
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    public float getTierAttackDamage() {
        return this.tierAttackDamage;
    }

    public int getEnchantability() {
        return this.enchantability;
    }

    @NotNull
    public TagKey<Block> getMiningTag() {
        return this.miningTag;
    }

    @NotNull
    public Supplier<Ingredient> getRepairIngredient() {
        return () -> this.repairIngredient;
    }

    public List<Object> getLowerRank() {
        if (this.lowerRank != null) {
            return List.of(this.lowerRank);
        }
        return List.of();
    }

    public List<Object> getHigherRank() {
        if (this.higherRank != null) {
            return List.of(this.higherRank);
        }
        return List.of();
    }
}

