/*
 * Decompiled with CFR 0.152.
 */
package com.riverstone.unknown303.errorlib.api.helpers.tier;

import com.riverstone.unknown303.errorlib.api.misc.CustomArmorMaterial;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.util.Lazy;

public class ErrorLibArmorMaterial
implements CustomArmorMaterial {
    private final ResourceLocation armorTypeId;
    private final int durabilityMultiplier;
    private final int[] protection;
    private final int enchantability;
    private final Lazy<SoundEvent> equipSound;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<Ingredient> repairIngredient;
    private static final int[] BASE_DURABILITY = new int[]{11, 16, 15, 13};

    ErrorLibArmorMaterial(String name, int durabilityMultiplier, int[] protection, int enchantability, Lazy<SoundEvent> equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        this(ResourceLocation.fromNamespaceAndPath((String)"errorlib", (String)name), durabilityMultiplier, protection, enchantability, equipSound, toughness, knockbackResistance, repairIngredient);
    }

    ErrorLibArmorMaterial(ResourceLocation name, int durabilityMultiplier, int[] protection, int enchantability, Lazy<SoundEvent> equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        this.armorTypeId = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.protection = protection;
        this.enchantability = enchantability;
        this.equipSound = equipSound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = repairIngredient;
    }

    @Override
    public ResourceLocation getId() {
        return this.armorTypeId;
    }

    public int m_266425_(ArmorItem.Type type) {
        return BASE_DURABILITY[type.ordinal()] * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.protection[type.ordinal()];
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return (SoundEvent)this.equipSound.get();
    }

    public Ingredient m_6230_() {
        return this.repairIngredient.get();
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }
}

