/*
 * Decompiled with CFR 0.152.
 */
package com.riverstone.unknown303.errorlib.api.helpers.registry;

import com.riverstone.unknown303.errorlib.api.general.ModInfo;
import com.riverstone.unknown303.errorlib.api.helpers.ErrorLibHelper;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;

public class RegistryHelper
extends ErrorLibHelper {
    public RegistryHelper(ModInfo modInfo) {
        super(modInfo);
    }

    public <T> IForgeRegistry<T> createRegistry(String registryId, Supplier<T> sup) {
        ResourceKey<Registry<T>> registryKey = this.key(registryId, sup);
        DeferredRegister REGISTRY = DeferredRegister.create(registryKey, (String)this.getModId());
        return (IForgeRegistry)REGISTRY.makeRegistry(RegistryBuilder::new).get();
    }

    private <T> ResourceKey<Registry<T>> key(String registryId, Supplier<T> sup) {
        return ResourceKey.m_135788_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.getModId(), (String)registryId));
    }

    public <T> List<T> getValidRegistrations(IForgeRegistry<T> reg, Supplier<T> sup) {
        return reg.getValues().stream().toList();
    }

    public <T> T getRegistration(IForgeRegistry<T> reg, String registryId, Supplier<T> sup) {
        return (T)reg.getValue(ResourceLocation.fromNamespaceAndPath((String)this.getModId(), (String)registryId));
    }
}

